/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.gui.UIRenderHelper;
import net.createmod.catnip.gui.element.AbstractRenderElement;
import net.createmod.catnip.gui.element.BoxElement;
import net.createmod.catnip.gui.element.FadableScreenElement;
import net.createmod.catnip.gui.widget.AbstractSimiWidget;
import net.createmod.catnip.gui.widget.ElementWidget;
import net.createmod.catnip.theme.Color;
import net.minecraft.class_332;

public class BoxWidget
extends ElementWidget {
    public static final Function<BoxWidget, FadableScreenElement> gradientFactory = box -> (ms, w, h, alpha) -> UIRenderHelper.angledGradient(ms, 90.0f, w / 2, -2, w + 4, h + 4, box.gradientColor);
    protected BoxElement box;
    @Nullable
    protected Couple<Color> customBorder;
    @Nullable
    protected Color customBackground;
    protected Couple<Color> colorIdle = AbstractSimiWidget.COLOR_IDLE;
    protected Couple<Color> colorHover = AbstractSimiWidget.COLOR_HOVER;
    protected Couple<Color> colorClick = AbstractSimiWidget.COLOR_CLICK;
    protected Couple<Color> colorDisabled = AbstractSimiWidget.COLOR_DISABLED;
    protected boolean animateColors = true;
    protected LerpedFloat colorAnimation = LerpedFloat.linear();
    protected Couple<Color> gradientColor;
    private Couple<Color> previousGradient;
    private Couple<Color> gradientTarget;

    public BoxWidget() {
        this(0, 0);
    }

    public BoxWidget(int x, int y) {
        this(x, y, 16, 16);
    }

    public BoxWidget(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.box = (BoxElement)new BoxElement().at(x, y).withBounds(width, height);
        this.gradientTarget = this.getColorIdle();
        this.gradientColor = this.gradientTarget;
        this.previousGradient = this.gradientTarget;
    }

    public <T extends BoxWidget> T withBounds(int width, int height) {
        this.field_22758 = width;
        this.field_22759 = height;
        return (T)this;
    }

    public <T extends BoxWidget> T withBorderColors(Couple<Color> colors) {
        this.customBorder = colors;
        this.updateGradientFromState();
        return (T)this;
    }

    public <T extends BoxWidget> T withBorderColors(Color top, Color bot) {
        return this.withBorderColors(Couple.create(top, bot));
    }

    public <T extends BoxWidget> T withCustomBackground(Color color) {
        this.customBackground = color;
        return (T)this;
    }

    public <T extends BoxWidget> T withCustomTheme(@Nullable Couple<Color> colorIdle, @Nullable Couple<Color> colorHover, @Nullable Couple<Color> colorClick, @Nullable Couple<Color> colorDisabled) {
        if (colorIdle != null) {
            this.colorIdle = colorIdle;
        }
        if (colorHover != null) {
            this.colorHover = colorHover;
        }
        if (colorClick != null) {
            this.colorClick = colorClick;
        }
        if (colorDisabled != null) {
            this.colorDisabled = colorDisabled;
        }
        this.updateGradientFromState();
        return (T)this;
    }

    public <T extends BoxWidget> T animateColors(boolean b) {
        this.animateColors = b;
        return (T)this;
    }

    @Override
    public void tick() {
        super.tick();
        this.colorAnimation.tickChaser();
    }

    @Override
    public void method_25348(double x, double y) {
        super.method_25348(x, y);
        this.gradientColor = this.getColorClick();
        this.startGradientAnimation(this.getColorForState(), 0.15);
    }

    @Override
    protected void beforeRender(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.beforeRender(graphics, mouseX, mouseY, partialTicks);
        RenderSystem.enableDepthTest();
        if (this.field_22762 != this.wasHovered) {
            this.animateGradientFromState();
        }
        if (this.colorAnimation.settled()) {
            this.gradientColor = this.gradientTarget;
        } else {
            float animationValue = 1.0f - Math.abs(this.colorAnimation.getValue(partialTicks));
            this.gradientColor = this.previousGradient.mapWithParams((prev, target) -> prev.mixWith((Color)target, animationValue), this.gradientTarget);
        }
    }

    @Override
    public void doRender(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        float fadeValue = this.fade.getValue(partialTicks);
        if (fadeValue < 0.1f) {
            return;
        }
        this.box.withAlpha(fadeValue);
        ((AbstractRenderElement)((BoxElement)this.box.withBackground(this.customBackground != null ? this.customBackground : BoxElement.COLOR_BACKGROUND_TRANSPARENT)).gradientBorder(this.gradientColor)).at(this.method_46426(), this.method_46427(), this.z).withBounds(this.field_22758, this.field_22759).render(graphics);
        super.doRender(graphics, mouseX, mouseY, partialTicks);
        this.wasHovered = this.field_22762;
    }

    public boolean method_25405(double mX, double mY) {
        if (!this.field_22763 || !this.field_22764) {
            return false;
        }
        float padX = 2.0f + this.paddingX;
        float padY = 2.0f + this.paddingY;
        return (double)((float)this.method_46426() - padX) <= mX && (double)((float)this.method_46427() - padY) <= mY && mX < (double)((float)this.method_46426() + padX + (float)this.field_22758) && mY < (double)((float)this.method_46427() + padY + (float)this.field_22759);
    }

    @Override
    protected boolean method_25361(double pMouseX, double pMouseY) {
        if (!this.field_22763 || !this.field_22764) {
            return false;
        }
        return this.method_25405(pMouseX, pMouseY);
    }

    public BoxElement getBox() {
        return this.box;
    }

    public void updateGradientFromState() {
        this.gradientTarget = this.getColorForState();
    }

    public void animateGradientFromState() {
        this.startGradientAnimation(this.getColorForState());
    }

    protected void startGradientAnimation(Couple<Color> target, double expSpeed) {
        if (!this.animateColors) {
            return;
        }
        this.colorAnimation.startWithValue(1.0);
        this.colorAnimation.chase(0.0, expSpeed, LerpedFloat.Chaser.EXP);
        this.colorAnimation.tickChaser();
        this.previousGradient = this.gradientColor;
        this.gradientTarget = target;
    }

    protected void startGradientAnimation(Couple<Color> target) {
        this.startGradientAnimation(target, 0.6);
    }

    protected Couple<Color> getColorForState() {
        if (!this.field_22763) {
            return this.getColorDisabled();
        }
        if (this.customBorder != null) {
            return this.field_22762 ? this.customBorder.map(Color::darker) : this.customBorder;
        }
        return this.field_22762 ? this.getColorHover() : this.getColorIdle();
    }

    public Couple<Color> getColorIdle() {
        return this.colorIdle;
    }

    public Couple<Color> getColorHover() {
        return this.colorHover;
    }

    public Couple<Color> getColorClick() {
        return this.colorClick;
    }

    public Couple<Color> getColorDisabled() {
        return this.colorDisabled;
    }
}

